<?php

/**
 * @package         EngageBox
 * @version         7.0.2 Pro
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\Field\GroupedlistField;

class JFormFieldEBAnimationIn extends GroupedlistField
{
    protected $layout = 'joomla.form.field.groupedlist-fancy-select';

    /**
     * Method to get a list of options for a list input.
     *
     * @return  array  An array of options.
     */
    protected function getGroups()
    {
        $data = [
			
			'Attention' => [
				'bounce' 		=> 'Bounce',
				'shakeX' 		=> 'Shake Horizontal',
				'shakeY' 		=> 'Shake Vertical',
				'headShake' 	=> 'Head Shake',
				'swing' 		=> 'Swing',
				'jello' 		=> 'Jello',
				'wobble' 		=> 'Wobble',
				'heartBeat' 	=> 'Heart Beat',
				'flash' 		=> 'Flash',
				'pulse' 		=> 'Pulse',
				'swing' 		=> 'Swing',
				'tada' 			=> 'Tada',
				'rubberBand'	=> 'Rubber Band',
			],
			
			'Classic' => [
				'fadeIn' => 'Fade In',
				'zoomIn' => 'Zoom In',
			],
			
			'Back Entrances' => [
				'backInDown'  => 'Back In from Bottom',
				'backInUp'    => 'Back In from Top',
				'backInLeft'  => 'Back In from Left',
				'backInRight' => 'Back In from Right',
			],
			'Bouncing Entrances' => [
				'bounceIn' 	 	=> 'Bounce In',
				'bounceInUp'  	=> 'Bounce In from Bottom',
				'bounceInDown'	=> 'Bounce In from Top',
				'bounceInLeft'	=> 'Bounce In from Left',
				'bounceInRight'	=> 'Bounce In from Right',
			],
			'Flip' => [
				'flip' 		=> 'Flip In',
				'flipInX' 	=> 'Flip In Horizontal',
				'flipInY' 	=> 'Flip In Vertical',
			],
			'Slide' => [
				'slideInDown' 		=> 'Slide In from Top',
				'slideInUp' 		=> 'Slide In from Bottom',
				'slideInLeft' 		=> 'Slide In from Left',
				'slideInRight' 		=> 'Slide In from Right',
				'fadeInUp' 			=> 'Slide In from Bottom & Fade In',
				'fadeInDown' 		=> 'Slide In from Top & Fade In',
				'fadeInLeft' 		=> 'Slide In from Left & Fade In',
				'fadeInRight' 		=> 'Slide In from Right & Fade In',
				'fadeInUpBig' 		=> 'Big Slide In from Bottom & Fade In',
				'fadeInDownBig' 	=> 'Big Slide In from Top & Fade In',
				'fadeInLeftBig' 	=> 'Big Slide In from Left & Fade In',
				'fadeInRightBig'	=> 'Big Slide In from Right & Fade In',
				'lightSpeedInRight' => 'Lightspeed Slide In from Right',
				'lightSpeedInLeft'  => 'Lightspeed Slide In from Left',
			],
			
		];

        $groups = [];

        foreach ($data as $groupKey => $value)
        {
            foreach ($value as $_key => $_value)
			{
				$groupLabel = '';
				
				$groupLabel = Text::_($groupKey);
				
				
                $groups[$groupLabel][] = HTMLHelper::_('select.option', $_key, $_value);
			}
        }

        return $groups;
    }
	
    protected function getInput()
    {
		$class = (string) $this->element['class'];

		$search_placeholder = (string) $this->element['search_placeholder'];
		if ($search_placeholder)
		{
			$this->class = $class . '" search-placeholder="' . Text::_($search_placeholder);
		}
		else
		{
			$this->class = $class;
		}

		return parent::getInput();
	}
}