<?php

/**
 * @package         EngageBox
 * @version         7.0.2 Pro
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2020 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

class JFormFieldEBTriggersList extends ListField
{
    /**
     * Method to get a list of options for a list input.
     *
     * @return    array   An array of options.
     */
    protected function getOptions()
    {
        $triggers = [
            'pageload'        => 'COM_RSTBOX_ITEM_TRIGGER_PAGELOAD',
            'onclick'         => 'COM_RSTBOX_ITEM_TRIGGER_ONCLICK',
            'ondemand'        => 'COM_RSTBOX_ITEM_TRIGGER_ONDEMAND',
            
            'pageheight'      => 'COM_RSTBOX_ITEM_TRIGGER_PAGEHEIGHT',
            'element'         => 'COM_RSTBOX_ITEM_TRIGGER_ELEMENT',
            'userleave'       => 'COM_RSTBOX_ITEM_TRIGGER_USERLEAVE',
            'elementHover'    => 'COM_RSTBOX_ITEM_TRIGGER_ELEMENTHOVER',
            'onAdBlockDetect' => 'COM_RSTBOX_ITEM_TRIGGER_ONADBLOCKDETECT',
            'onIdle'          => 'COM_RSTBOX_ITEM_TRIGGER_ONIDLE',
            'onexternallink'  => 'COM_RSTBOX_ITEM_TRIGGER_ONEXTERNALLINK',
            'floatingbutton'  => 'COM_RSTBOX_ITEM_TRIGGER_FLOATINGBUTTON'
            
        ];

        foreach ($triggers as $key => $title)
        {
            $options[] = HTMLHelper::_('select.option', $key, Text::_($title));
        }   

        return array_merge(parent::getOptions(), $options);
    }
}