<?php

/**
 * @package         EngageBox
 * @version         7.0.2 Pro
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2019 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;

class JFormFieldOpeningSoundList extends ListField
{
    /**
     * Method to get a list of options for a list input.
     *
     * @return      array
     */
    protected function getOptions()
    {
        $doc = Factory::getDocument();
        
        // Load Opening Behavior Previewer
        $doc->addScriptOptions('engagebox_editor_object', [
            'siteUrl' => Uri::root()
        ]);
        HTMLHelper::script('com_rstbox/opening_sound.js', ['relative' => true, 'version' => 'auto']);
        
        $items = [
            '' => 'NR_NONE',
            'file' => 'COM_RSTBOX_OPENING_SOUND_FILE',
            'url' => 'COM_RSTBOX_OPENING_SOUND_URL',
            'earth' => 'COM_RSTBOX_OPENING_SOUND_EARTH',
            'jupiter' => 'COM_RSTBOX_OPENING_SOUND_JUPITER',
            'mars' => 'COM_RSTBOX_OPENING_SOUND_MARS',
            'moon' => 'COM_RSTBOX_OPENING_SOUND_MOON',
            'uranus' => 'COM_RSTBOX_OPENING_SOUND_URANUS'
        ];

        foreach ($items as $key => $value)
        {
            $options[] = HTMLHelper::_('select.option', $key, Text::_($value));
        }

        return array_merge(parent::getOptions(), $options);
    }
}