<?php
/**  
 * JS APP renderer system plugin - opera con i parametri del componente
 * @package SCREENREADER::plugins::system
 * @author Joomla! Extensions Store 
 * @copyright (C) 2015 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
// no direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\Event\Event;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Plugin\PluginHelper;

class PlgSystemScreenReader extends CMSPlugin implements SubscriberInterface {
	/**
	 * App reference
	 *
	 * @access protected
	 * @var Object
	 */
	protected $appInstance;
	
	/**
	 * onAfterInitialise handler
	 *
	 * Aggiunge nel page document output la JS APP
	 * 
	 * @param Event $event
	 * @access public
	 * @return null
	 */
	public function screenreaderDispatch(Event $event) {
		// Execute solo nel frontend
		if ($this->appInstance->isClient ('site') || $this->params->get ( 'screenreader_administration', 0 )) {
			// Check for menu exclusion
			$menu = $this->appInstance->getMenu ()->getActive ();
			if (is_object ( $menu )) {
				$menuItemid = $menu->id;
				$menuExcluded = $this->params->get ( 'screenreader_exclusions', 0 );
				if (is_array ( $menuExcluded ) && ! in_array ( 0, $menuExcluded, false ) && in_array ( $menuItemid, $menuExcluded )) {
					return;
				}
			}

			// load the language object and the translation accordingly
			$language = $this->appInstance->getLanguage ();
			$langTag = $language->getTag ();
			
			// Check for language exclusion
			$excludedLanguages = $this->params->get ( 'excluded_languages', array() );
			if(in_array($langTag, $excludedLanguages)) {
				return;
			}
			
			if($this->params->get ( 'sef_lang_code', 1 )) {
				$explodedLangTag = explode ( '-', $langTag );
				$langCode = array_shift ( $explodedLangTag );
			} else {
				$langCode = $langTag;
			}
			
			$token = md5 ( $_SERVER ["HTTP_HOST"] );
			
			// Security safe
			if (! file_exists ( JPATH_SITE . '/plugins/system/screenreader/screenreader/languages/' . $langTag . '.js' )) {
				$langTag = 'en-GB';
			}
			
			$base = Uri::root (false);
			// Ottenimento document
			$doc = $this->appInstance->getDocument ();
			// Output JS APP nel Document
			$tmplType = $this->appInstance->getInput()->get('tmpl');
			if ($doc->getType () !== 'html' || $tmplType === 'component') {
				return false;
			}
			
			// Gestione params plugin php / options plugin js
			$pparams = new \stdClass ();
			$pparams->volume_tts = $this->params->get ( 'volume_tts', 80 );
			$pparams->voice_speed = $this->params->get ( 'voice_speed', 'normal' );
			$pparams->chunksize = $this->params->get ( 'chunksize', 300 );
			$pparams->position = $this->params->get ( 'corner_position', 'bottomright' );
			$pparams->template = $this->params->get ( 'template', 'elegant.css' );
			$pparams->template_orientation = $this->params->get ( 'template_orientation', 'vertical' );
			$pparams->scrolling = $this->params->get ( 'scrolling', 'fixed' );
			$pparams->target_appendto = $this->params->get ( 'target_appendto', 'html' );
			$pparams->target_append_mode = $this->params->get ( 'target_append_mode', 'bottom' );
			$pparams->enable_dark_mode = $this->params->get ( 'enable_dark_mode', 0 );
			$pparams->enable_accessibility_statement = $this->params->get ( 'enable_accessibility_statement', 0 );
			$pparams->enable_accessibility_statement_text = Text::_($this->params->get ( 'enable_accessibility_statement_text', 'Accessibility statement' ), true);
			$pparams->enable_accessibility_statement_link = $this->params->get ( 'enable_accessibility_statement_link', '' );
			$pparams->hide_on_mobile = $this->params->get ( 'hide_on_mobile', 0 );
			$pparams->use_minimized_toolbar = $this->params->get ( 'use_minimized_toolbar', 1 );
			$pparams->status_minimized_toolbar = $this->params->get ( 'status_minimized_toolbar', 'closed' );
			$pparams->minimized_toolbar_only_mobile = $this->params->get ( 'minimized_toolbar_only_mobile', 0 );
			$pparams->fontsize_minimized_toolbar = $this->params->get ( 'fontsize_minimized_toolbar', 0 );
			$pparams->hover_minimized_toolbar = $this->params->get ( 'hover_minimized_toolbar', 0 );
			$pparams->preload = $this->params->get ( 'preload', 1 );
			$pparams->preload_timeout = $this->params->get( 'preload_timeout', 3000);
			$pparams->auto_background_color = $this->params->get ( 'auto_background_color', 1 );
			$pparams->read_page = $this->params->get ( 'read_page', 1 );
			$pparams->read_child_nodes = $this->params->get ( 'read_child_nodes', 1 );
			$pparams->exclude_scripts = $this->params->get ( 'exclude_scripts', 1 );
			$pparams->ie_highcontrast = $this->params->get ( 'ie_highcontrast', 1 );
			$pparams->ie_highcontrast_advanced = $this->params->get ( 'ie_highcontrast_advanced', 1 );
			$pparams->selected_storage = $this->params->get ( 'selected_storage', 'session' );
			$pparams->gtranslate_integration = $this->params->get( 'gtranslate_integration', 0);
			$pparams->select_mainpagearea_text = $this->params->get( 'select_mainpagearea_text', 0);
			$pparams->reset_button_behavior = $this->params->get ( 'reset_button_behavior', 'fontsize' );
			$pparams->read_elements_hovering = $this->params->get ( 'read_elements_hovering', 0 );
			$pparams->elements_hovering_selector = trim ( $this->params->get ( 'elements_hovering_selector', 'p' ), ',' );
			$pparams->elements_toexclude_custom = trim ( $this->params->get ( 'elements_toexclude_custom', '' ), ',' );
			
			$pparams->read_images = $this->params->get ( 'read_images', 0 );
			$pparams->read_images_attribute = $this->params->get ( 'read_images_attribute', 'alt' );
			$pparams->read_images_ordering = $this->params->get ( 'read_images_ordering', 'before' );
			$pparams->read_images_hovering = $this->params->get ( 'read_images_hovering', 0 );
			
			$pparams->mainpage_selector = trim ( $this->params->get ( 'mainpage_selector', '*[name*=main], *[class*=main], *[id*=main], *[id*=container], *[class*=container]', ''), ',' );
			$pparams->showlabel = $this->params->get ( 'showlabel', 1 );
			$pparams->labelText = Text::_($this->params->get ( 'labeltext', 'Screen Reader'), true);
			$pparams->screenreader_icon = $this->params->get ( 'screenreader_icon', 'audio' );
			$pparams->screenreader_icon_custom = $this->params->get ( 'screenreader_icon_custom', null );

			$pparams->screenreader = $this->params->get ( 'screenreader', 1 );
			$pparams->highcontrast = $this->params->get ( 'highcontrast', 1 );
			$pparams->highcontrast_alternate = $this->params->get ( 'highcontrast_alternate', 1 );
			$pparams->highcontrast_alternate_color_hue = $this->params->get ( 'highcontrast_alternate_color_hue', 180 );
			$pparams->highcontrast_alternate_color_brightness = $this->params->get ( 'highcontrast_alternate_color_brightness', 6 );
			$pparams->highcontrast_root_target = $this->params->get ( 'highcontrast_root_target', 0 );
			$pparams->dyslexic_font = $this->params->get ( 'dyslexic_font', 0 );
			$pparams->gray_hues = $this->params->get ( 'gray_hues', 0 );
			$pparams->spacing_size = $this->params->get ( 'spacing_size', 0 );
			$pparams->page_zoom = $this->params->get ( 'page_zoom', 0 );
			$pparams->big_cursor = $this->params->get ( 'big_cursor', 0 );
			$pparams->reading_guides = $this->params->get ( 'reading_guides', 0 );
			$pparams->readability = $this->params->get ( 'readability', 0 );
			$pparams->readability_selector = trim ( $this->params->get ( 'readability_selector', 'div.item-page,#content,div[itemprop=articleBody],div.item-content' ), ',' );
			$pparams->hide_images = $this->params->get ( 'hide_images', 0 );
			$pparams->hide_also_videos_iframes = $this->params->get ( 'hide_also_videos_iframes', 0 );
			$pparams->fontsize = $this->params->get ( 'fontsize', 1 );
			$pparams->font_size_default = $this->params->get ( 'font_size_default', 80 );
			$pparams->font_size_min = $this->params->get ( 'font_size_min', 50 );
			$pparams->font_size_max = $this->params->get ( 'font_size_max', 200 );
			$pparams->spacing_size_min = $this->params->get ( 'spacing_size_min', 0 );
			$pparams->spacing_size_max = $this->params->get ( 'spacing_size_max', 10 );
			$pparams->fontsize_selector = trim ( $this->params->get ( 'fontsize_selector', '' ), ',' );
			$pparams->fontsize_headers_increment = $this->params->get ( 'fontsize_headers_increment', 20 );
			$pparams->toolbar_bgcolor = $this->params->get ( 'toolbar_bgcolor', '#EEEEEE' );
			$pparams->reader_engine = $this->params->get ( 'reader_engine', 'proxy_responsive' );
			$pparams->customcolors = $this->params->get ( 'customcolors', 0 );
			$pparams->customcolors_cssselectors = trim ( $this->params->get ( 'customcolors_cssselectors', '' ), ',' );
			
			// Check if mobile needs a separate reader engine
			$pparams->use_mobile_reader_engine = $this->params->get ( 'use_mobile_reader_engine', 0 );
			$pparams->mobile_reader_engine = $this->params->get ( 'mobile_reader_engine', 'proxy_responsive' );
			$pparams->proxy_responsive_apikey = trim($this->params->get ( 'proxy_responsive_apikey', 'kWyXm5dC' ));
			$pparams->proxy_responsive_language_gender = trim($this->params->get ( 'proxy_responsive_language_gender', 'auto' ));
			$pparams->proxy_responsive_loading_script = $this->params->get ( 'proxy_responsive_loading_script', 0 );
			
			// Accessibility improvements
			$pparams->show_skip_to_contents = $this->params->get ( 'show_skip_to_contents', 0 );
			$pparams->skiptocontents_selector = $this->params->get ( 'skiptocontents_selector', '' );
			$pparams->enable_focus_outline = $this->params->get ( 'enable_focus_outline', 0 );
			$pparams->enable_focus_outline_color = $this->params->get ( 'enable_focus_outline_color', '#F00' );
			$pparams->enable_focus_outline_bordersize = $this->params->get ( 'enable_focus_outline_bordersize', '2px' );
			$pparams->remove_links_target = $this->params->get ( 'remove_links_target', 0 );
			
			// Accesskeys
			$pparams->accesskey_play = trim($this->params->get ( 'accesskey_play', 'P' ));
			$pparams->accesskey_pause = trim($this->params->get ( 'accesskey_pause', 'E' ));
			$pparams->accesskey_stop = trim($this->params->get ( 'accesskey_stop', 'S' ));
			$pparams->accesskey_increase = trim($this->params->get ( 'accesskey_increase', 'O' ));
			$pparams->accesskey_decrease = trim($this->params->get ( 'accesskey_decrease', 'U' ));
			$pparams->accesskey_reset = trim($this->params->get ( 'accesskey_reset', 'R' ));
			$pparams->accesskey_highcontrast = trim($this->params->get ( 'accesskey_highcontrast', 'H' ));
			$pparams->accesskey_highcontrast2 = trim($this->params->get ( 'accesskey_highcontrast2', 'J' ));
			$pparams->accesskey_highcontrast3 = trim($this->params->get ( 'accesskey_highcontrast3', 'K' ));
			$pparams->accesskey_dyslexic = trim($this->params->get ( 'accesskey_dyslexicfont', 'D' ));
			$pparams->accesskey_grayhues = trim($this->params->get ( 'accesskey_grayhues', 'G' ));
			$pparams->accesskey_spacingsize_increase = trim($this->params->get ( 'accesskey_spacingsize_increase', 'M' ));
			$pparams->accesskey_spacingsize_decrease = trim($this->params->get ( 'accesskey_spacingsize_decrease', 'N' ));
			$pparams->accesskey_pagezoomsize_increase = trim($this->params->get ( 'accesskey_pagezoomsize_increase', 'X' ));
			$pparams->accesskey_pagezoomsize_decrease = trim($this->params->get ( 'accesskey_pagezoomsize_decrease', 'Y' ));
			$pparams->accesskey_pagezoomsize_reset = trim($this->params->get ( 'accesskey_pagezoomsize_reset', 'Z' ));
			$pparams->accesskey_skiptocontents = trim($this->params->get ( 'accesskey_skiptocontents', 'C' ));
			$pparams->accesskey_bigcursor = trim($this->params->get ( 'accesskey_bigcursor', 'W' ));
			$pparams->accesskey_reading_guides = trim($this->params->get ( 'accesskey_reading_guides', 'V' ));
			$pparams->accesskey_readability = trim($this->params->get ( 'accesskey_readability', 'Q' ));
			$pparams->accesskey_hideimages = trim($this->params->get ( 'accesskey_hideimages', 'F' ));
			$pparams->accesskey_grayhues = trim($this->params->get ( 'accesskey_grayhues', 'G' ));
			$pparams->accesskey_minimized = trim($this->params->get ( 'accesskey_minimized', 'L' ));
			$pparams->volume_accesskeys = trim($this->params->get ( 'volume_accesskeys', 1 ));
			$pparams->accesskey_increase_volume = trim($this->params->get ( 'accesskey_increase_volume', '+' ));
			$pparams->accesskey_decrease_volume = trim($this->params->get ( 'accesskey_decrease_volume', '-' ));
			$pparams->accesskey_change_text_color = trim($this->params->get ( 'accesskey_change_text_color', 'I' ));
			$pparams->accesskey_change_background_color = trim($this->params->get ( 'accesskey_change_background_color', 'B' ));
			
			// Ensure that the chunk length is correct for Responsive Voice Greek
			if($pparams->reader_engine == 'proxy_responsive' && $langTag == 'el-GR' && $pparams->chunksize > 200) {
				$pparams->chunksize = 200;
			}
			
			// Ensure that the chunk length is correct for Google
			if($pparams->reader_engine == 'proxy' && $pparams->chunksize > 100) {
				$pparams->chunksize = 100;
			}
			
			// Ensure that the chunk length is correct for ISpeech
			if($pparams->reader_engine == 'proxy_ispeech' && $pparams->chunksize > 90) {
				$pparams->chunksize = 90;
			}
			
			// Ensure that the chunk length is correct for Virtual Readers
			if($pparams->reader_engine == 'proxy_virtual_free') {
				if($pparams->chunksize >= 300) {
					$pparams->chunksize = 280;
				}
				$pparams->preload = 1;
			}
			
			// Override params for texttomp3 optimization
			if(($pparams->reader_engine == 'proxy_texttomp3')) {
				$pparams->chunksize = 300;
				$pparams->preload = 1;
			}
			
			// Override params for neospeech optimization
			if(($pparams->reader_engine == 'proxy_neospeech')) {
				if($pparams->chunksize < 400) {
					$pparams->chunksize = 400;
				}
				$pparams->preload = 1;
			}
			
			$jQueryInclusion = $this->params->get ( 'jquery_include', 1 );
			
			// Exceptions force settings for the accessible template
			if($pparams->template == 'accessible.css') {
				$pparams->template_orientation = 'vertical';
				$pparams->use_minimized_toolbar = 1;
				$pparams->minimized_toolbar_only_mobile = 0;
				$pparams->target_appendto = 'html';
				$pparams->scrolling = 'fixed';
			}
			
			$doc->getWebAssetManager()->registerAndUseStyle ( 'screenreader.template', 'plugins/system/screenreader/screenreader/libraries/controller/css/' . $pparams->template);
			
			$doc->getWebAssetManager()->addInlineStyle('#accessibility-links #text_plugin{width:' . (int)$this->params->get ( 'labelwidth', 80 ) . 'px;}');
			
			if($toolbarBorderRadius = (int)$this->params->get ( 'toolbar_border_radius', 0 )) {
				$doc->getWebAssetManager()->addInlineStyle('div#accessibility-links,div#accessibility-links.bottomleft,div#accessibility-links.topleft,div#accessibility-links.bottomright,div#accessibility-links.topright,div#tts_message,div#accessibility-links div#msgtext,div#accessibility-links div#playicon{border-radius:' . $toolbarBorderRadius . 'px;}');
			}
			
			$wa = $doc->getWebAssetManager();
			if ($jQueryInclusion) {
				$wa->useScript('jquery');
				$wa->useScript('jquery-noconflict');
			}
			
			if($this->params->get('force_jquery_deferred', 0)) {
				$wa->registerAndUseScript ( 'screenreader.jquery', 'plugins/system/screenreader/screenreader/libraries/jquery/jquery.js', [], ['defer'=>true, 'async'=>false]);
			}
			$scriptLoading = $this->params->get('script_loading', 'deferred') == 'deferred' ? true : false;
			
			$wa->registerAndUseScript ( 'screenreader.languages', 'plugins/system/screenreader/screenreader/languages/' . $langTag . '.js');
			
			// Screen reader script
			$wa->registerAndUseScript ( 'screenreader.soundmanager2', 'plugins/system/screenreader/screenreader/libraries/tts/soundmanager/soundmanager2.js');
			
			// Add the responsivevoice script
			$dependencyResponsiveVoice = ['jquery'];
			if($pparams->reader_engine == 'proxy_responsive' || ($pparams->use_mobile_reader_engine && $pparams->mobile_reader_engine == 'proxy_responsive')) {
				$dependencyResponsiveVoice = ['jquery', 'screenreader.responsivevoice'];
				if($pparams->proxy_responsive_loading_script == 0) {
					$wa->registerAndUseScript ( 'screenreader.responsivevoice', 'plugins/system/screenreader/screenreader/libraries/tts/responsivevoice.js', [], ['defer'=>$scriptLoading, 'async'=>false]);
				}else {
					$wa->registerAndUseScript ( 'screenreader.responsivevoice', 'https://code.responsivevoice.org/responsivevoice.js?key=' . $pparams->proxy_responsive_apikey, [], ['defer'=>$scriptLoading, 'async'=>false]);
				}
			}
			
			// Async scripts to avoid jQuery prototype overriding
			$wa->registerAndUseScript ( 'screenreader.tts', 'plugins/system/screenreader/screenreader/libraries/tts/tts.js', [], ['defer'=>$scriptLoading, 'async'=>false], $dependencyResponsiveVoice);
			$wa->registerAndUseScript ( 'screenreader.controller', 'plugins/system/screenreader/screenreader/libraries/controller/controller.js', [], ['defer'=>$scriptLoading, 'async'=>false], ['jquery', 'screenreader.tts']);
			
			// Add focusable outline if enabled
			if($pparams->enable_focus_outline) {
				$doc->getWebAssetManager()->addInlineStyle(":focus{outline: $pparams->enable_focus_outline_bordersize solid $pparams->enable_focus_outline_color !important;}");
			}
			
			// Add custom image icon
			if($pparams->screenreader_icon == 'custom') {
				if($pparams->template == 'accessible.css') {
					$doc->getWebAssetManager()->addInlineStyle(	"div.scbasebin.screenreader.text.scr_customicon{background: url(" . $base . $pparams->screenreader_icon_custom . ") no-repeat center center;background-size: 32px 32px}" .
																"div#accessibility-links #toolbar_plugin{background: url(" . $base . $pparams->screenreader_icon_custom . ") no-repeat center left 8px;background-size: 32px 32px;padding-left: 5px}");
				} else {
					$doc->getWebAssetManager()->addInlineStyle("div.scbasebin.screenreader.text.scr_customicon{background: url(" . $base . $pparams->screenreader_icon_custom . ") no-repeat 4px 2px;background-size: 32px 32px}");
				}
			}
			
			$doc->getWebAssetManager()->addInlineScript (
										 "window.soundManager.url = '{$base}plugins/system/screenreader/screenreader/libraries/tts/soundmanager/swf/';
										  window.soundManager.debugMode = false;  
										  window.soundManager.defaultOptions.volume = $pparams->volume_tts;
										  var screenReaderConfigOptions = {	baseURI: '$base',
																			token: '$token',
																			langCode: '$langCode',
																			chunkLength: $pparams->chunksize,
																			screenReaderVolume: '$pparams->volume_tts',
																			screenReaderVoiceSpeed: '$pparams->voice_speed',
																			position: '$pparams->position',
																			scrolling: '$pparams->scrolling',
																			targetAppendto: '$pparams->target_appendto',
																			targetAppendMode: '$pparams->target_append_mode',
																			enableDarkMode: $pparams->enable_dark_mode,
																			enableAccessibilityStatement: $pparams->enable_accessibility_statement,
																			enableAccessibilityStatementText: '$pparams->enable_accessibility_statement_text',
																			enableAccessibilityStatementLink: '{$base}$pparams->enable_accessibility_statement_link',
																			preload: $pparams->preload,
																			preloadTimeout: $pparams->preload_timeout,
																			autoBackgroundColor: $pparams->auto_background_color,
																			readPage: $pparams->read_page,
																			readChildNodes: $pparams->read_child_nodes,
																			ieHighContrast: $pparams->ie_highcontrast,
																			ieHighContrastAdvanced: $pparams->ie_highcontrast_advanced,
																			selectedStorage: '$pparams->selected_storage',
																			gtranslateIntegration: $pparams->gtranslate_integration,
																			readElementsHovering: $pparams->read_elements_hovering,
																			elementsHoveringSelector: '$pparams->elements_hovering_selector',
																			elementsToexcludeCustom: '$pparams->elements_toexclude_custom',
																			selectMainpageareaText: $pparams->select_mainpagearea_text,
																			excludeScripts: $pparams->exclude_scripts,
																			readImages: $pparams->read_images,
																			readImagesAttribute: '$pparams->read_images_attribute',
																			readImagesOrdering: '$pparams->read_images_ordering',
																			readImagesHovering: $pparams->read_images_hovering,
																			mainpageSelector: '$pparams->mainpage_selector',
																			showlabel: $pparams->showlabel,
																			labeltext: '$pparams->labelText',
																			screenreaderIcon: '$pparams->screenreader_icon',
																			screenreader: $pparams->screenreader,
																			highcontrast: $pparams->highcontrast,
																			highcontrastAlternate: $pparams->highcontrast_alternate,
																			colorHue: $pparams->highcontrast_alternate_color_hue,
																			colorBrightness: $pparams->highcontrast_alternate_color_brightness,
																			rootTarget: $pparams->highcontrast_root_target,
																			dyslexicFont: $pparams->dyslexic_font,
																			grayHues: $pparams->gray_hues,
																			spacingSize: $pparams->spacing_size,
																			spacingSizeMin: $pparams->spacing_size_min,
																			spacingSizeMax: $pparams->spacing_size_max,
																			pageZoom: $pparams->page_zoom,
																			bigCursor: $pparams->big_cursor,
																			readingGuides: $pparams->reading_guides,
																			readability: $pparams->readability,
																			readabilitySelector: '$pparams->readability_selector',
																			hideImages: $pparams->hide_images,
																			hideAlsoVideosIframes: $pparams->hide_also_videos_iframes,
																			customColors: $pparams->customcolors,
																			customColorsCssSelectors: '$pparams->customcolors_cssselectors',
																			fontsizeMinimizedToolbar: $pparams->fontsize_minimized_toolbar,
																			hoverMinimizedToolbar: $pparams->hover_minimized_toolbar,
																			fontsize: $pparams->fontsize,
																			fontsizeDefault: $pparams->font_size_default,
																			fontsizeMin: $pparams->font_size_min,
																			fontsizeMax: $pparams->font_size_max,
																			fontsizeSelector: '$pparams->fontsize_selector',
																			fontSizeHeadersIncrement: $pparams->fontsize_headers_increment,
																			toolbarBgcolor: '$pparams->toolbar_bgcolor',
																			template: '$pparams->template',
																			templateOrientation: '$pparams->template_orientation',
																			accesskey_play: '$pparams->accesskey_play',
																			accesskey_pause: '$pparams->accesskey_pause',
																			accesskey_stop: '$pparams->accesskey_stop',
																			accesskey_increase: '$pparams->accesskey_increase',
																			accesskey_decrease: '$pparams->accesskey_decrease',
																			accesskey_reset: '$pparams->accesskey_reset',
																			accesskey_highcontrast: '$pparams->accesskey_highcontrast',
																			accesskey_highcontrast2: '$pparams->accesskey_highcontrast2',
																			accesskey_highcontrast3: '$pparams->accesskey_highcontrast3',
																			accesskey_dyslexic: '$pparams->accesskey_dyslexic',
																			accesskey_grayhues: '$pparams->accesskey_grayhues',
																			accesskey_spacingsize_increase: '$pparams->accesskey_spacingsize_increase',
																			accesskey_spacingsize_decrease: '$pparams->accesskey_spacingsize_decrease',
																			accesskey_pagezoomsize_increase: '$pparams->accesskey_pagezoomsize_increase',
																			accesskey_pagezoomsize_decrease: '$pparams->accesskey_pagezoomsize_decrease',
																			accesskey_pagezoomsize_reset: '$pparams->accesskey_pagezoomsize_reset',
																			accesskey_bigcursor: '$pparams->accesskey_bigcursor',
																			accesskey_reading_guides: '$pparams->accesskey_reading_guides',
																			accesskey_readability: '$pparams->accesskey_readability',
																			accesskey_hideimages: '$pparams->accesskey_hideimages',
																			accesskey_skiptocontents: '$pparams->accesskey_skiptocontents',
																			accesskey_minimized: '$pparams->accesskey_minimized',
																			volume_accesskeys: $pparams->volume_accesskeys,
																			accesskey_increase_volume: '$pparams->accesskey_increase_volume',
																			accesskey_decrease_volume: '$pparams->accesskey_decrease_volume',
																			accesskey_change_text_color: '$pparams->accesskey_change_text_color',
																			accesskey_change_background_color: '$pparams->accesskey_change_background_color',
																			readerEngine: '$pparams->reader_engine',
																			useMobileReaderEngine: $pparams->use_mobile_reader_engine,
																			mobileReaderEngine: '$pparams->mobile_reader_engine',
																			proxyResponsiveApikey: '$pparams->proxy_responsive_apikey',
																			proxyResponsiveLanguageGender: '$pparams->proxy_responsive_language_gender',
																			hideOnMobile: $pparams->hide_on_mobile,
																			useMinimizedToolbar: $pparams->use_minimized_toolbar,
																			statusMinimizedToolbar: '$pparams->status_minimized_toolbar',
																			minimizedToolbarOnlyMobile: $pparams->minimized_toolbar_only_mobile,
																			showSkipToContents: $pparams->show_skip_to_contents,
																			skipToContentsSelector: '$pparams->skiptocontents_selector',
																			removeLinksTarget: $pparams->remove_links_target,
																			resetButtonBehavior: '$pparams->reset_button_behavior'
																		};" );
		}
	}
	
	/**
	 * Screen Reader {play} button J 3+
	 *
	 * @param Event $event
	 * @subparam   string  The context of the content being passed to the plugin.
	 *
	 * @return array A two element array of (imageName, textToInsert)
	 */
	public function screenreaderPrepareData(Event $event) {
		// subparams: $context
		$arguments = $event->getArguments();
		$context = isset($arguments[0]) ? $event->getArgument(0) : $event->getArgument('context');
		$data = isset($arguments[1]) ? $event->getArgument(1) : $event->getArgument('data');
		
		if ( $this->appInstance->isClient ('administrator') && 
			 $this->params->get ( 'editor_xtd_button', 1 ) && 
			($context == 'com_content.article' || ($context == 'com_modules.module' && $data->module == 'mod_custom'))) {
			$doc = $this->appInstance->getDocument();
			$doc->getWebAssetManager()->useScript('jquery');
			$doc->getWebAssetManager()->useScript('jquery-noconflict');
			$targetContext = $context == 'com_content.article' ? 'jform_articletext' : 'jform_content';
			$buttonCode = <<<BUTTON
					if(typeof(jQuery) !== 'undefined') {
						if (document.querySelector('script[type=importmap]')) {
						  import('editor-api')
						    .then(editorApiModule => {
						    	window.screenreaderEditorReference = editorApiModule.JoomlaEditor;
						    })
						    .catch(error => {
						    	console.error('An error occurred while loading the module: ', error);
						    });
						}
						jQuery(function($){
							if($('div.toggle-editor.btn-toolbar,div.editor-xtd-buttons').length) {
								window.scrInsertPlayBtn = function() {
									if(typeof(window.screenreaderEditorReference) !== 'undefined' && window.screenreaderEditorReference.getActive()) {
										var editorReference = window.screenreaderEditorReference.get('$targetContext');
										editorReference.replaceSelection(codeToAdd);
									} else {
										Joomla.editors.instances['$targetContext'].replaceSelection(codeToAdd);
									}
									return false;
								};
								var codeToAdd = '<span class="screenreader_embed_play_button"> {Play}</span>';
								var codeToAppend = '<a class="btn btn-secondary ms-1" href="javascript:void(0);" onclick="window.scrInsertPlayBtn();"><span class="icon-play-2"></span> ScreenReader Play</a>';
								$('div.toggle-editor.btn-toolbar,div.editor-xtd-buttons').append(codeToAppend);
							};
						});
					};
BUTTON;
			$doc->getWebAssetManager()->addInlineScript($buttonCode, [], ['type'=>'module']);
		}
	}
	
	/**
	 * Event to manipulate the menu item dashboard in backend
	 *
	 * @param Event $event
	 * @subparam   array  &$policy  The privacy policy status data, passed by reference, with keys "published" and "editLink"
	 *
	 * @return  void
	 */
	public function processMenuItemsDashboard(Event $event) {
		$arguments = $event->getArguments();
		
		// Kill com_joomlaupdate informations about extensions missing updater info, leave only main one
		$document = $this->appInstance->getDocument();
		if(!$this->appInstance->get('jextstore_joomlaupdate_script') && $this->appInstance->getInput()->get('option') == 'com_joomlaupdate' && !$this->appInstance->getInput()->get('view') && !$this->appInstance->getInput()->get('task')) {
			$document->getWebAssetManager()->addInlineScript ("
				window.addEventListener('DOMContentLoaded', function(e) {
					if(document.querySelector('#preupdatecheck')) {
						var jextensionsIntervalCount = 0;
						var jextensionsIntervalTimer = setInterval(function() {
						    [].slice.call(document.querySelectorAll('#compatibilityTable1 tbody tr th.exname')).forEach(function(th) {
						        let txt = th.innerText;
						        if (txt && txt.toLowerCase().match(/jsitemap|gdpr|gptranslate|jpagebuilder|responsivizer|jchatsocial|jcomment|jshortcodes|jrealtime|jspeed|jredirects|vsutility|visualstyles|visual\sstyles|instant\sfacebook\slogin|instantpaypal|screen\sreader|jspeed|jamp/i)) {
						            th.parentElement.style.display = 'none';
						            th.parentElement.classList.remove('error');
									th.parentElement.classList.add('jextcompatible');
						        }
						    });
							[].slice.call(document.querySelectorAll('#compatibilityTable2 tbody tr th.exname')).forEach(function(th) {
						        let txt = th.innerText;
						        if (txt && txt.toLowerCase().match(/jsitemap|gdpr|gptranslate|jpagebuilder|responsivizer|jchatsocial|jcomment|jshortcodes|jrealtime|jspeed|jredirects|vsutility|visualstyles|visual\sstyles|instant\sfacebook\slogin|instantpaypal|screen\sreader|jspeed|jamp/i)) {
									th.parentElement.classList.remove('error');
									th.parentElement.classList.add('jextcompatible');
						            let smallDiv = th.querySelector(':scope div.small');
									if(smallDiv) {
										smallDiv.style.display = 'none';
									}
						        }
						    });
							if (document.querySelectorAll('#compatibilityTable0 tbody tr').length == 0 &&
								document.querySelectorAll('#compatibilityTable1 tbody tr:not(.jextcompatible)').length == 0 &&
								document.querySelectorAll('#compatibilityTable2 tbody tr:not(.jextcompatible)').length == 0) {
						        [].slice.call(document.querySelectorAll('#preupdatecheckbox, #preupdateCheckCompleteProblems')).forEach(function(element) {
						            element.style.display = 'none';
						        });
								if(document.querySelector('#noncoreplugins')) {
									document.querySelector('#noncoreplugins').checked = true;
								}
								if(document.querySelector('button.submitupdate')) {
							        document.querySelector('button.submitupdate').disabled = false;
							        document.querySelector('button.submitupdate').classList.remove('disabled');
								}
								if(document.querySelector('#joomlaupdate-precheck-extensions-tab span.fa')) {
									let tabIcon = document.querySelector('#joomlaupdate-precheck-extensions-tab span.fa');
									tabIcon.classList.remove('fa-times');
									tabIcon.classList.remove('text-danger');
									tabIcon.classList.remove('fa-exclamation-triangle');
									tabIcon.classList.remove('text-warning');
									tabIcon.classList.add('fa-check');
									tabIcon.classList.add('text-success');
								}
						    };
					
							if (document.querySelectorAll('#compatibilityTable0 tbody tr').length == 0) {
								if(document.querySelectorAll('#compatibilityTable1 tbody tr:not(.jextcompatible)').length == 0) {
									let compatibilityTable1 = document.querySelector('#compatibilityTable1');
									if(compatibilityTable1) {
										compatibilityTable1.style.display = 'none';
									}
								}
								clearInterval(jextensionsIntervalTimer);
							}
					
						    jextensionsIntervalCount++;
						}, 1000);
					};
				});");
			$this->appInstance->set('jextstore_joomlaupdate_script', true);
		}
	}
	
	/** Manage the Joomla updater based on the user license
	 *
	 * @param Event $event
	 * @subparam   string  The $url for the package update download
	 * @subparam   array  The headers array.
	 * @access public
	 * @return void
	 */
	public function screenreaderUpdateInstall(Event $event) {
		// subparams: &$url, &$headers
		$arguments = $event->getArguments();
		$url = isset($arguments[0]) ? $event->getArgument(0) : $event->getArgument('url');
		$headers = isset($arguments[1]) ? $event->getArgument(1) : $event->getArgument('headers');
		
		$uri 	= Uri::getInstance($url);
		$parts 	= explode('/', $uri->getPath());
		if ($uri->getHost() == 'storejextensions.org' && in_array('plg_screenreader.zip', $parts)) {
			// Init as false unless the license is valid
			$validUpdate = false;
	
			// Manage partial language translations
			$jLang = $this->appInstance->getLanguage();
			$jLang->load('plg_system_screenreader', JPATH_ADMINISTRATOR, 'en-GB', true, true);
	
			// Email license validation API call and &$url building construction override
			$plugin = PluginHelper::getPlugin('system', 'screenreader');
			$pluginParams = json_decode($plugin->params);
			$registrationEmail = $pluginParams->registration_email;
	
			// License
			if($registrationEmail) {
				$prodCode = 'screenreader';
				$cdFuncUsed = 'str_' . 'ro' . 't' . '13';
	
				// Retrieve license informations from the remote REST API
				$apiResponse = null;
				$apiEndpoint = $cdFuncUsed('uggc' . '://' . 'fgberwrkgrafvbaf' . '.bet') . "/option,com_easycommerce/action,licenseCode/email,$registrationEmail/productcode,$prodCode";
				if (function_exists('curl_init')){
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, $apiEndpoint);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					$apiResponse = curl_exec($ch);
					curl_close($ch);
				}
				$objectApiResponse = json_decode($apiResponse);
	
				if(!is_object($objectApiResponse)) {
					// Message user about error retrieving license informations
					$this->appInstance->enqueueMessage(Text::_('PLG_SCREENREADER_ERROR_RETRIEVING_LICENSE_INFO'));
				} else {
					if(!$objectApiResponse->success) {
						switch ($objectApiResponse->reason) {
							// Message user about the reason the license is not valid
							case 'nomatchingcode':
								$this->appInstance->enqueueMessage(Text::_('PLG_SCREENREADER_LICENSE_NOMATCHING'));
								break;
	
							case 'expired':
								// Message user about license expired on $objectApiResponse->expireon
								$this->appInstance->enqueueMessage(Text::sprintf('PLG_SCREENREADER_LICENSE_EXPIRED', $objectApiResponse->expireon));
								break;
						}
							
					}
	
					// Valid license found, builds the URL update link and message user about the license expiration validity
					if($objectApiResponse->success) {
						$url = $cdFuncUsed('uggc' . '://' . 'fgberwrkgrafvbaf' . '.bet' . '/FPE1406TSPQsagf9853560923ernq35td1xvg89i.ugzy');
						// Joomla 5+ native BeforePackageDownloadEvent
						if(method_exists($event, 'updateUrl')) {
							$event->updateUrl($url);
						} else {
							// Fallback to generic Event up to Joomla 4
							$event->setArgument(0, $url);
						}
						$validUpdate = true;
						$this->appInstance->enqueueMessage(Text::sprintf('PLG_SCREENREADER_EXTENSION_UPDATED_SUCCESS', $objectApiResponse->expireon));
					}
				}
			} else {
				// Message user about missing email license code
				$this->appInstance->enqueueMessage(Text::_('PLG_SCREENREADER_MISSING_REGISTRATION_EMAIL_ADDRESS'));
			}
	
			if(!$validUpdate) {
				$this->appInstance->enqueueMessage(Text::_('PLG_SCREENREADER_UPDATER_STANDARD_ADVISE'), 'notice');
			}
		}
	}
	
	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 *
	 * @since 4.0.0
	 */
	public static function getSubscribedEvents(): array {
		return [
				'onAfterDispatch' => 'screenreaderDispatch',
				'onContentPrepareData' => 'screenreaderPrepareData',
				'onPreprocessMenuItems' => 'processMenuItemsDashboard',
				'onInstallerBeforePackageDownload' => 'screenreaderUpdateInstall'
		];
	}
	
	/**
	 * Class constructor, manage params from component
	 *
	 * @access private
	 * @return boolean
	 */
	public function __construct(& $subject, $config = array()) {
		parent::__construct ( $subject, $config );
		
		// Init application
		$this->appInstance = Factory::getApplication();
	}
}