<?php
/**  
 * @package SCREENREADER::plugins::system
 * @subpackage libraries
 * @subpackage fields
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html   
 */ 
defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;

/**
 * Form Field for menu tree
 * @package SCREENREADER::plugins::system
 * @subpackage libraries 
 * @subpackage fields
 * @since 2.4
 */
class JFormFieldMenuMultiselect extends ListField {
	/**
	 * Method to attach a JForm object to the field.
	 *
	 * @param SimpleXMLElement $element
	 *        	The SimpleXMLElement object representing the `<field>` tag for the form field object.
	 * @param mixed $value
	 *        	The form field value to validate.
	 * @param string $group
	 *        	The field name group control value. This acts as as an array container for the field.
	 *        	For example if the field has name="foo" and the group value is set to "bar" then the
	 *        	full field name would end up being "bar[foo]".
	 *
	 * @return boolean True on success.
	 *
	 * @since 11.1
	 */
	public function setup(\SimpleXMLElement $element, $value, $group = null) {
		parent::setup ( $element, $value, $group );
	
		$this->default = isset ( $element ['value'] ) ? ( string ) $element ['value'] : array (
				$this->default
		);
	
		// Add custom JS to rework bootstrap popovers for the label description
		$doc = Factory::getApplication()->getDocument();
		// Include jQuery/Bootstrap framework
		$wa = $doc->getWebAssetManager();
		$wa->useScript('jquery');
		$wa->useScript('jquery-noconflict');
		array_map ( function ($script) use ($wa) {
			$wa->useScript ( 'bootstrap.' . $script );
		}, [
				'popover'
		] );
		$popoverTitle = Text::_('PLG_SCREENREADER_SUPPORTED_LANGUAGES_BY_ENGINE', true);
		$script = <<<EOL
		jQuery(function($){
			var smallText = $('div.control-group small.form-text').hide();
			smallText.each(function(index, elem){
				var parentContainer = $(elem).parents('div.control-group');
				var targetLabel = $('div.control-label label,div.controls legend', parentContainer);
				var sourceDescription = $(elem).html();
				targetLabel.attr('title', $(targetLabel.get(0)).text());
				targetLabel.attr('data-bs-content', sourceDescription);
				targetLabel.addClass('hasPopover');
				targetLabel.attr('aria-haspopup', 'true');
			});
			[].slice.call(document.querySelectorAll('div.control-group label.hasPopover,div.controls legend.hasPopover')).map(function (popoverEl) {
					return new bootstrap.Popover(popoverEl, {
												 "template":'<div class="popover"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>',
												 "container":"body",
												 "html":true,
												 "placement":"top",
												 "trigger":"hover focus"
				});
			});

			var engineLanguagesMapping = {
				'proxy_responsive' : 'Afrikaans, Albanian, Arabic, Armenian, Bangla, Bosnian, Brazilian Portuguese, Catalan, Chinese, Croatian, Czech, Danish, Dutch, English, Esperanto, French, Finnish, German, Greek, Hindi, Hungarian, Icelandic, Indonesian, Italian, Japanese, Korean, Latvian, Macedonian, Norwegian, Portuguese, Polish, Romanian, Russian, Serbian, Slovak, Spanish, Swedish, Swahili, Tamil, Thai, Turkish, Vietnamese, Welsh',
				'proxy' : 'Afrikaans, Albanian, Arabic, Armenian, Bosnian, Brazilian Portuguese, Catalan, Chinese, Croatian, Czech, Danish, Dutch, English, Esperanto, French, Finnish, German, Greek, Hebrew, Hindi, Hungarian, Icelandic, Indonesian, Italian, Japanese, Korean, Latvian, Macedonian, Norwegian, Portuguese, Polish, Romanian, Russian, Serbian, Slovak, Spanish, Swedish, Swahili, Tamil, Thai, Turkish, Ukraninan, Vietnamese, Welsh',
				'proxy_virtual_free' : 'Arabic, Brazilian Portuguese, Catalan, Czech, Danish, Dutch, English, Faroese, French, Finnish, German, Greek, Italian, Japanese, Korean, Norwegian, Portuguese, Polish, Russian, Spanish, Swedish, Turkish',
				'proxy_ispeech' : 'Arabic, Bulgarian, Catalan, Chinese, Croatian, Czech, Danish, Dutch, English, Finnish, French, German, Greek, Hebrew, Hindi, Hungarian, Indonesian, Italian, Japanese, Korean, Malay, Norwegian, Polish, Portuguese, Romanian, Russian, Slovak, Slovenian, Spanish, Swedish, Tamil, Thai, Turkish, Vietnamese',
				'proxy_inforobo' : 'Arabic, Armenian, Brazilian Portuguese, Chinese, Croatian, Czech, Danish, Dutch, English, French, Finnish, German, Greek, Hindi, Hungarian, Indonesian, Italian, Japanese, Korean, Norwegian, Portuguese, Polish, Romanian, Russian, Slovak, Spanish, Swedish, Turkish, Vietnamese, Welsh',
				'proxy_texttomp3' : 'Arabic, Brazilian Portuguese, Catalan, Czech, Chinese, Danish, Dutch, English, Finnish, French, German, Greek, Hindi, Hungarian, Indonesian, Italian, Japanese, Korean, Norwegian, Polish, Portuguese, Polish, Romanian, Russian, Slovak, Spanish, Swedish, Thai, Turkish, Ukraninan',
				'proxy_ttsmp3' : 'Arabic, Brazilian Portuguese, Chinese, Danish, Dutch, English, French, German, Italian, Japanese, Korean, Norwegian, Portuguese, Polish, Russian, Spanish, Swedish, Turkish, Welsh'	
			};
						
			var popoverTimeout = [];
			var targetEngineDropdown = $('#jform_params_reader_engine, #jform_params_mobile_reader_engine');
			targetEngineDropdown.on('click', function(jqEvent){
				showLanguagesPopover(jqEvent.target);
			});
			var showLanguagesPopover = function(element) {
				var dropdownValue = $(element).val();
				if(typeof(popoverTimeout[element.id]) !== 'undefined') {
					clearTimeout(popoverTimeout[element.id]);
				}
 
				let popoverEl = element;
				let popoverInstance = bootstrap.Popover.getInstance(popoverEl);
				if(popoverInstance) {
					popoverInstance.dispose();
				}
				
				targetEngineDropdown.attr('data-bs-content', engineLanguagesMapping[dropdownValue]);
				targetEngineDropdown.attr('data-bs-original-title', '$popoverTitle');
				popoverInstance = new bootstrap.Popover(popoverEl, {
										 "template":'<div class="popover"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>',
										 "container":"body",
										 "html":true,
										 "placement":"right",
										 "trigger":"manual"
				});

				popoverInstance.show();
				popoverTimeout[element.id] = setTimeout(function(){
					let popoverInstance = bootstrap.Popover.getInstance(popoverEl);
					if(popoverInstance) {
						popoverInstance.dispose();
					}
				}, 5000);	
			}

			$('input.field-media-input').each(function(index, elem){
			    $(elem).css('visibility','hidden');
			});
			// Observe media field image selection change
			$('div.field-media-preview').each(function(index, elem){
				// Create an observer instance for each element to observe
				var observer = new MutationObserver(function(mutations) {
					var image = $('img', elem);
					if(image.length) {
						let relatedInputField = $(elem).next('div').find('input.field-media-input');
						relatedInputField.val(relatedInputField.val().split('#')[0]);
					}
				});
				observer.observe(elem, { childList: true });
			});
			setTimeout(function(){
			    $('input.field-media-input').each(function(index, elem){
					elem.value = elem.value.split('#')[0];
					$(elem).css('visibility','visible');
			    }); 
			}, 300);

			$(document).on('change', '#jform_params_template', function(){
				var currentSelectedTemplate = $(this).val();
				if(currentSelectedTemplate == 'accessible.css') {
					$('#jform_params_template_orientation').val('vertical');
					$('#jform_params_scrolling').val('fixed');
					$('#jform_params_use_minimized_toolbar1').prop('checked', true).attr('checked', 'checked');
					$('label[for=jform_params_use_minimized_toolbar1]').addClass('active');
					$('label[for=jform_params_use_minimized_toolbar0]').removeClass('active');
					$('#jform_params_target_appendto').val('html');
				}
			});
		});
EOL;
		$doc->getWebAssetManager()->addInlineScript($script);
	
		return true;
	}
	
	/**
	 * Tree recursion menu
	 * 
	 * @access private 
	 * @param int $id
	 * @param string $indent
	 * @param array $list
	 * @param array $children
	 * @param int $maxlevel
	 * @param int $level
	 * @param int $type
	 * @return array
	 */
	private static function treeRecurse($id, $indent, $list, &$children, $maxlevel = 9999, $level = 0, $type = 1) {
		if (@$children [$id] && $level <= $maxlevel) {
			foreach ( $children [$id] as $v ) {
				$id = $v->id;
	
				if ($type) {
					$pre = '<sup>|_</sup>&nbsp;';
					$spacer = '.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
				} else {
					$pre = '- ';
					$spacer = '&nbsp;&nbsp;';
				}
	
				if ($v->parent == 0) {
					$txt = $v->name;
				} else {
					$txt = $pre . $v->name;
				}
				$pt = $v->parent;
				$list [$id] = $v;
				$list [$id]->treename = "$indent$txt";
				$list [$id]->children = isset($children [$id]) ? count ( $children [$id] ) : 0;
				$list = self::treeRecurse ( $id, $indent . $spacer, $list, $children, $maxlevel, $level + 1, $type );
			}
		}
		return $list;
	}
	
	/**
	 * Build the multiple select list for Menu Links/Pages
	 * 
	 * @access public
	 * @return array
	 */
	protected function getOptions() {
		// Add the css file for plugin settings styling
		$doc = Factory::getApplication()->getDocument ();
		$doc->getWebAssetManager()->registerAndUseStyle ( 'screenreader.main', 'plugins/system/screenreader/css/main.css');
		
		$db = Factory::getContainer()->get('DatabaseDriver');
		
		// get a list of the menu items
		$query = 'SELECT m.id, m.parent_id AS parent, m.title AS name, m.menutype, t.title' .
				' FROM #__menu AS m' .
				' INNER JOIN #__menu_types AS t' .
				' ON m.menutype = t.menutype' .
				' WHERE m.published = 1' .
				' AND m.client_id = 0' .
				' ORDER BY m.menutype, m.parent_id, m.lft';
		$db->setQuery ( $query );
		$mitems = $db->loadObjectList ();
		$mitems_temp = $mitems;
		
		if(empty($mitems)) {
			return $mitems;
		}
		
		// establish the hierarchy of the menu
		$children = array ();
		// first pass - collect children
		foreach ( $mitems as $v ) {
			$id = $v->id;
			$pt = $v->parent;
			$list = @$children [$pt] ? $children [$pt] : array ();
			array_push ( $list, $v );
			$children [$pt] = $list;
		}
		// second pass - get an indent list of the items
		$list = self::treeRecurse ( intval ( $mitems [0]->parent ), '', array (), $children, 9999, 0, 0 );
		
		// Code that adds menu name to Display of Page(s)
		$mitems_spacer = $mitems_temp [0]->menutype;
		
		$mitems = array ();
		$lastMenuType = null;
		$tmpMenuType = null;
		foreach ( $list as $list_a ) {
			if ($list_a->menutype != $lastMenuType) {
				if ($tmpMenuType) {
					$mitems [] = HTMLHelper::_ ( 'select.option', '</OPTGROUP>' );
				}
				$mitems [] = HTMLHelper::_ ( 'select.option', '<OPTGROUP>', $list_a->title );
				$lastMenuType = $list_a->menutype;
				$tmpMenuType = $list_a->menutype;
			}
			
			$mitems [] = HTMLHelper::_ ( 'select.option', $list_a->id, $list_a->treename );
		}
		if ($lastMenuType !== null) {
			$mitems [] = HTMLHelper::_ ( 'select.option', '</OPTGROUP>' );
		}
		
		$noActiveOption = HTMLHelper::_('select.option', '0', Text::_('PLG_SCREENREADER_NOEXCLUSION'));
		array_unshift($mitems, $noActiveOption);
		
		return $mitems;
	}
}